# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.messaging.webpubsubservice import WebPubSubServiceClient
from devtools_testutils import AzureRecordedTestCase, PowerShellPreparer
import functools


class WebPubSubServiceClientTestBase(AzureRecordedTestCase):

    def create_client(self, endpoint):
        credential = self.get_credential(WebPubSubServiceClient)
        return self.create_client_from_credential(
            WebPubSubServiceClient,
            credential=credential,
            endpoint=endpoint,
        )


WebPubSubServicePreparer = functools.partial(
    PowerShellPreparer, "webpubsubservice", webpubsubservice_endpoint="https://fake_webpubsubservice_endpoint.com"
)
