// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: errorpb.proto

package errorpb

import (
	"fmt"
	"io"
	"math"

	proto "github.com/golang/protobuf/proto"

	_ "github.com/gogo/protobuf/gogoproto"

	metapb "github.com/pingcap/kvproto/pkg/metapb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// NotLeader is the error variant that tells a request be handle by raft leader
// is sent to raft follower or learner.
type NotLeader struct {
	// The requested region ID
	RegionId uint64 `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Region leader of the requested region
	Leader               *metapb.Peer `protobuf:"bytes,2,opt,name=leader" json:"leader,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *NotLeader) Reset()         { *m = NotLeader{} }
func (m *NotLeader) String() string { return proto.CompactTextString(m) }
func (*NotLeader) ProtoMessage()    {}
func (*NotLeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{0}
}
func (m *NotLeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NotLeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NotLeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *NotLeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NotLeader.Merge(dst, src)
}
func (m *NotLeader) XXX_Size() int {
	return m.Size()
}
func (m *NotLeader) XXX_DiscardUnknown() {
	xxx_messageInfo_NotLeader.DiscardUnknown(m)
}

var xxx_messageInfo_NotLeader proto.InternalMessageInfo

func (m *NotLeader) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *NotLeader) GetLeader() *metapb.Peer {
	if m != nil {
		return m.Leader
	}
	return nil
}

type DiskFull struct {
	// The requested store ID
	StoreId []uint64 `protobuf:"varint,1,rep,packed,name=store_id,json=storeId" json:"store_id,omitempty"`
	// The detailed info
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiskFull) Reset()         { *m = DiskFull{} }
func (m *DiskFull) String() string { return proto.CompactTextString(m) }
func (*DiskFull) ProtoMessage()    {}
func (*DiskFull) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{1}
}
func (m *DiskFull) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DiskFull) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DiskFull.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *DiskFull) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiskFull.Merge(dst, src)
}
func (m *DiskFull) XXX_Size() int {
	return m.Size()
}
func (m *DiskFull) XXX_DiscardUnknown() {
	xxx_messageInfo_DiskFull.DiscardUnknown(m)
}

var xxx_messageInfo_DiskFull proto.InternalMessageInfo

func (m *DiskFull) GetStoreId() []uint64 {
	if m != nil {
		return m.StoreId
	}
	return nil
}

func (m *DiskFull) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

// StoreNotMatch is the error variant that tells the request is sent to wrong store.
// (i.e. inconsistency of the store ID that request shows and the real store ID of this server.)
type StoreNotMatch struct {
	// Store id in request
	RequestStoreId uint64 `protobuf:"varint,1,opt,name=request_store_id,json=requestStoreId,proto3" json:"request_store_id,omitempty"`
	// Actual store id
	ActualStoreId        uint64   `protobuf:"varint,2,opt,name=actual_store_id,json=actualStoreId,proto3" json:"actual_store_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StoreNotMatch) Reset()         { *m = StoreNotMatch{} }
func (m *StoreNotMatch) String() string { return proto.CompactTextString(m) }
func (*StoreNotMatch) ProtoMessage()    {}
func (*StoreNotMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{2}
}
func (m *StoreNotMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreNotMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreNotMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StoreNotMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreNotMatch.Merge(dst, src)
}
func (m *StoreNotMatch) XXX_Size() int {
	return m.Size()
}
func (m *StoreNotMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreNotMatch.DiscardUnknown(m)
}

var xxx_messageInfo_StoreNotMatch proto.InternalMessageInfo

func (m *StoreNotMatch) GetRequestStoreId() uint64 {
	if m != nil {
		return m.RequestStoreId
	}
	return 0
}

func (m *StoreNotMatch) GetActualStoreId() uint64 {
	if m != nil {
		return m.ActualStoreId
	}
	return 0
}

// RegionNotFound is the error variant that tells there isn't any region in this TiKV
// matches the requested region ID.
type RegionNotFound struct {
	// The requested region ID
	RegionId             uint64   `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegionNotFound) Reset()         { *m = RegionNotFound{} }
func (m *RegionNotFound) String() string { return proto.CompactTextString(m) }
func (*RegionNotFound) ProtoMessage()    {}
func (*RegionNotFound) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{3}
}
func (m *RegionNotFound) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionNotFound) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionNotFound.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RegionNotFound) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionNotFound.Merge(dst, src)
}
func (m *RegionNotFound) XXX_Size() int {
	return m.Size()
}
func (m *RegionNotFound) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionNotFound.DiscardUnknown(m)
}

var xxx_messageInfo_RegionNotFound proto.InternalMessageInfo

func (m *RegionNotFound) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

// RegionNotInitialized is the error variant that tells there isn't any initialized peer
// matchesthe request region ID.
type RegionNotInitialized struct {
	// The request region ID
	RegionId             uint64   `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegionNotInitialized) Reset()         { *m = RegionNotInitialized{} }
func (m *RegionNotInitialized) String() string { return proto.CompactTextString(m) }
func (*RegionNotInitialized) ProtoMessage()    {}
func (*RegionNotInitialized) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{4}
}
func (m *RegionNotInitialized) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionNotInitialized) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionNotInitialized.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RegionNotInitialized) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionNotInitialized.Merge(dst, src)
}
func (m *RegionNotInitialized) XXX_Size() int {
	return m.Size()
}
func (m *RegionNotInitialized) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionNotInitialized.DiscardUnknown(m)
}

var xxx_messageInfo_RegionNotInitialized proto.InternalMessageInfo

func (m *RegionNotInitialized) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

// KeyNotInRegion is the error variant that tells the key the request requires isn't present in
// this region.
type KeyNotInRegion struct {
	// The requested key
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The requested region ID
	RegionId uint64 `protobuf:"varint,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Start key of the requested region
	StartKey []byte `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// Snd key of the requested region
	EndKey               []byte   `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyNotInRegion) Reset()         { *m = KeyNotInRegion{} }
func (m *KeyNotInRegion) String() string { return proto.CompactTextString(m) }
func (*KeyNotInRegion) ProtoMessage()    {}
func (*KeyNotInRegion) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{5}
}
func (m *KeyNotInRegion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyNotInRegion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyNotInRegion.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *KeyNotInRegion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyNotInRegion.Merge(dst, src)
}
func (m *KeyNotInRegion) XXX_Size() int {
	return m.Size()
}
func (m *KeyNotInRegion) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyNotInRegion.DiscardUnknown(m)
}

var xxx_messageInfo_KeyNotInRegion proto.InternalMessageInfo

func (m *KeyNotInRegion) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *KeyNotInRegion) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *KeyNotInRegion) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *KeyNotInRegion) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

// EpochNotMatch is the error variant that tells a region has been updated.
// (e.g. by splitting / merging, or raft Confchange.)
// Hence, a command is based on a stale version of a region.
type EpochNotMatch struct {
	// Available regions that may be siblings of the requested one.
	CurrentRegions       []*metapb.Region `protobuf:"bytes,1,rep,name=current_regions,json=currentRegions" json:"current_regions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *EpochNotMatch) Reset()         { *m = EpochNotMatch{} }
func (m *EpochNotMatch) String() string { return proto.CompactTextString(m) }
func (*EpochNotMatch) ProtoMessage()    {}
func (*EpochNotMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{6}
}
func (m *EpochNotMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EpochNotMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EpochNotMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *EpochNotMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EpochNotMatch.Merge(dst, src)
}
func (m *EpochNotMatch) XXX_Size() int {
	return m.Size()
}
func (m *EpochNotMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EpochNotMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EpochNotMatch proto.InternalMessageInfo

func (m *EpochNotMatch) GetCurrentRegions() []*metapb.Region {
	if m != nil {
		return m.CurrentRegions
	}
	return nil
}

// ServerIsBusy is the error variant that tells the server is too busy to response.
type ServerIsBusy struct {
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// The suggested backoff time
	BackoffMs            uint64   `protobuf:"varint,2,opt,name=backoff_ms,json=backoffMs,proto3" json:"backoff_ms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerIsBusy) Reset()         { *m = ServerIsBusy{} }
func (m *ServerIsBusy) String() string { return proto.CompactTextString(m) }
func (*ServerIsBusy) ProtoMessage()    {}
func (*ServerIsBusy) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{7}
}
func (m *ServerIsBusy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerIsBusy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServerIsBusy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ServerIsBusy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerIsBusy.Merge(dst, src)
}
func (m *ServerIsBusy) XXX_Size() int {
	return m.Size()
}
func (m *ServerIsBusy) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerIsBusy.DiscardUnknown(m)
}

var xxx_messageInfo_ServerIsBusy proto.InternalMessageInfo

func (m *ServerIsBusy) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ServerIsBusy) GetBackoffMs() uint64 {
	if m != nil {
		return m.BackoffMs
	}
	return 0
}

// StaleCommand is the error variant that tells the command is stale, that is,
// the current request term is lower than current raft term.
// This can be retried at most time.
type StaleCommand struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StaleCommand) Reset()         { *m = StaleCommand{} }
func (m *StaleCommand) String() string { return proto.CompactTextString(m) }
func (*StaleCommand) ProtoMessage()    {}
func (*StaleCommand) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{8}
}
func (m *StaleCommand) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StaleCommand) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StaleCommand.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StaleCommand) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StaleCommand.Merge(dst, src)
}
func (m *StaleCommand) XXX_Size() int {
	return m.Size()
}
func (m *StaleCommand) XXX_DiscardUnknown() {
	xxx_messageInfo_StaleCommand.DiscardUnknown(m)
}

var xxx_messageInfo_StaleCommand proto.InternalMessageInfo

// RaftEntryTooLarge is the error variant that tells the request is too large to be serialized to a
// reasonable small raft entry.
// (i.e. greater than the configured value `raft_entry_max_size` in `raftstore`)
type RaftEntryTooLarge struct {
	// The requested region ID
	RegionId uint64 `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Size of the raft entry
	EntrySize            uint64   `protobuf:"varint,2,opt,name=entry_size,json=entrySize,proto3" json:"entry_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RaftEntryTooLarge) Reset()         { *m = RaftEntryTooLarge{} }
func (m *RaftEntryTooLarge) String() string { return proto.CompactTextString(m) }
func (*RaftEntryTooLarge) ProtoMessage()    {}
func (*RaftEntryTooLarge) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{9}
}
func (m *RaftEntryTooLarge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftEntryTooLarge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftEntryTooLarge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RaftEntryTooLarge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftEntryTooLarge.Merge(dst, src)
}
func (m *RaftEntryTooLarge) XXX_Size() int {
	return m.Size()
}
func (m *RaftEntryTooLarge) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftEntryTooLarge.DiscardUnknown(m)
}

var xxx_messageInfo_RaftEntryTooLarge proto.InternalMessageInfo

func (m *RaftEntryTooLarge) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *RaftEntryTooLarge) GetEntrySize() uint64 {
	if m != nil {
		return m.EntrySize
	}
	return 0
}

// MaxTimestampNotSynced is the error variant that tells the peer has just become a leader and
// updating the max timestamp in the concurrency manager from PD TSO is ongoing. In this case,
// the prewrite of an async commit transaction cannot succeed. The client can backoff and
// resend the request.
type MaxTimestampNotSynced struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MaxTimestampNotSynced) Reset()         { *m = MaxTimestampNotSynced{} }
func (m *MaxTimestampNotSynced) String() string { return proto.CompactTextString(m) }
func (*MaxTimestampNotSynced) ProtoMessage()    {}
func (*MaxTimestampNotSynced) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{10}
}
func (m *MaxTimestampNotSynced) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MaxTimestampNotSynced) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MaxTimestampNotSynced.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MaxTimestampNotSynced) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MaxTimestampNotSynced.Merge(dst, src)
}
func (m *MaxTimestampNotSynced) XXX_Size() int {
	return m.Size()
}
func (m *MaxTimestampNotSynced) XXX_DiscardUnknown() {
	xxx_messageInfo_MaxTimestampNotSynced.DiscardUnknown(m)
}

var xxx_messageInfo_MaxTimestampNotSynced proto.InternalMessageInfo

// ReadIndexNotReady is the error variant that tells the read index request is not ready, that is,
// the current region is in a status that not ready to serve the read index request. For example,
// region is in splitting or merging status.
// This can be retried at most time.
type ReadIndexNotReady struct {
	// The reason why the region is not ready to serve read index request
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// The requested region ID
	RegionId             uint64   `protobuf:"varint,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadIndexNotReady) Reset()         { *m = ReadIndexNotReady{} }
func (m *ReadIndexNotReady) String() string { return proto.CompactTextString(m) }
func (*ReadIndexNotReady) ProtoMessage()    {}
func (*ReadIndexNotReady) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{11}
}
func (m *ReadIndexNotReady) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadIndexNotReady) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadIndexNotReady.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadIndexNotReady) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadIndexNotReady.Merge(dst, src)
}
func (m *ReadIndexNotReady) XXX_Size() int {
	return m.Size()
}
func (m *ReadIndexNotReady) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadIndexNotReady.DiscardUnknown(m)
}

var xxx_messageInfo_ReadIndexNotReady proto.InternalMessageInfo

func (m *ReadIndexNotReady) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ReadIndexNotReady) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

// ProposalInMergingMode is the error variant that tells the proposal is rejected because raft is
// in the merging mode. This may happen when BR/Lightning try to ingest SST.
// This can be retried at most time.
type ProposalInMergingMode struct {
	// The requested region ID
	RegionId             uint64   `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProposalInMergingMode) Reset()         { *m = ProposalInMergingMode{} }
func (m *ProposalInMergingMode) String() string { return proto.CompactTextString(m) }
func (*ProposalInMergingMode) ProtoMessage()    {}
func (*ProposalInMergingMode) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{12}
}
func (m *ProposalInMergingMode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProposalInMergingMode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProposalInMergingMode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ProposalInMergingMode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProposalInMergingMode.Merge(dst, src)
}
func (m *ProposalInMergingMode) XXX_Size() int {
	return m.Size()
}
func (m *ProposalInMergingMode) XXX_DiscardUnknown() {
	xxx_messageInfo_ProposalInMergingMode.DiscardUnknown(m)
}

var xxx_messageInfo_ProposalInMergingMode proto.InternalMessageInfo

func (m *ProposalInMergingMode) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

type DataIsNotReady struct {
	// The requested region ID
	RegionId             uint64   `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	PeerId               uint64   `protobuf:"varint,2,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	SafeTs               uint64   `protobuf:"varint,3,opt,name=safe_ts,json=safeTs,proto3" json:"safe_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataIsNotReady) Reset()         { *m = DataIsNotReady{} }
func (m *DataIsNotReady) String() string { return proto.CompactTextString(m) }
func (*DataIsNotReady) ProtoMessage()    {}
func (*DataIsNotReady) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{13}
}
func (m *DataIsNotReady) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataIsNotReady) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataIsNotReady.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *DataIsNotReady) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataIsNotReady.Merge(dst, src)
}
func (m *DataIsNotReady) XXX_Size() int {
	return m.Size()
}
func (m *DataIsNotReady) XXX_DiscardUnknown() {
	xxx_messageInfo_DataIsNotReady.DiscardUnknown(m)
}

var xxx_messageInfo_DataIsNotReady proto.InternalMessageInfo

func (m *DataIsNotReady) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *DataIsNotReady) GetPeerId() uint64 {
	if m != nil {
		return m.PeerId
	}
	return 0
}

func (m *DataIsNotReady) GetSafeTs() uint64 {
	if m != nil {
		return m.SafeTs
	}
	return 0
}

type RecoveryInProgress struct {
	// The requested region ID
	RegionId             uint64   `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RecoveryInProgress) Reset()         { *m = RecoveryInProgress{} }
func (m *RecoveryInProgress) String() string { return proto.CompactTextString(m) }
func (*RecoveryInProgress) ProtoMessage()    {}
func (*RecoveryInProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{14}
}
func (m *RecoveryInProgress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecoveryInProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RecoveryInProgress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RecoveryInProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecoveryInProgress.Merge(dst, src)
}
func (m *RecoveryInProgress) XXX_Size() int {
	return m.Size()
}
func (m *RecoveryInProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_RecoveryInProgress.DiscardUnknown(m)
}

var xxx_messageInfo_RecoveryInProgress proto.InternalMessageInfo

func (m *RecoveryInProgress) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

// Error wraps all region errors, indicates an error encountered by a request.
type Error struct {
	// The error message
	Message               string                 `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	NotLeader             *NotLeader             `protobuf:"bytes,2,opt,name=not_leader,json=notLeader" json:"not_leader,omitempty"`
	RegionNotFound        *RegionNotFound        `protobuf:"bytes,3,opt,name=region_not_found,json=regionNotFound" json:"region_not_found,omitempty"`
	KeyNotInRegion        *KeyNotInRegion        `protobuf:"bytes,4,opt,name=key_not_in_region,json=keyNotInRegion" json:"key_not_in_region,omitempty"`
	EpochNotMatch         *EpochNotMatch         `protobuf:"bytes,5,opt,name=epoch_not_match,json=epochNotMatch" json:"epoch_not_match,omitempty"`
	ServerIsBusy          *ServerIsBusy          `protobuf:"bytes,6,opt,name=server_is_busy,json=serverIsBusy" json:"server_is_busy,omitempty"`
	StaleCommand          *StaleCommand          `protobuf:"bytes,7,opt,name=stale_command,json=staleCommand" json:"stale_command,omitempty"`
	StoreNotMatch         *StoreNotMatch         `protobuf:"bytes,8,opt,name=store_not_match,json=storeNotMatch" json:"store_not_match,omitempty"`
	RaftEntryTooLarge     *RaftEntryTooLarge     `protobuf:"bytes,9,opt,name=raft_entry_too_large,json=raftEntryTooLarge" json:"raft_entry_too_large,omitempty"`
	MaxTimestampNotSynced *MaxTimestampNotSynced `protobuf:"bytes,10,opt,name=max_timestamp_not_synced,json=maxTimestampNotSynced" json:"max_timestamp_not_synced,omitempty"`
	ReadIndexNotReady     *ReadIndexNotReady     `protobuf:"bytes,11,opt,name=read_index_not_ready,json=readIndexNotReady" json:"read_index_not_ready,omitempty"`
	ProposalInMergingMode *ProposalInMergingMode `protobuf:"bytes,12,opt,name=proposal_in_merging_mode,json=proposalInMergingMode" json:"proposal_in_merging_mode,omitempty"`
	DataIsNotReady        *DataIsNotReady        `protobuf:"bytes,13,opt,name=data_is_not_ready,json=dataIsNotReady" json:"data_is_not_ready,omitempty"`
	RegionNotInitialized  *RegionNotInitialized  `protobuf:"bytes,14,opt,name=region_not_initialized,json=regionNotInitialized" json:"region_not_initialized,omitempty"`
	DiskFull              *DiskFull              `protobuf:"bytes,15,opt,name=disk_full,json=diskFull" json:"disk_full,omitempty"`
	// Online recovery is still in performing, reject writes to avoid potential issues
	RecoveryInProgress   *RecoveryInProgress `protobuf:"bytes,16,opt,name=RecoveryInProgress" json:"RecoveryInProgress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_errorpb_643166a07278d6aa, []int{15}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Error.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(dst, src)
}
func (m *Error) XXX_Size() int {
	return m.Size()
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

func (m *Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Error) GetNotLeader() *NotLeader {
	if m != nil {
		return m.NotLeader
	}
	return nil
}

func (m *Error) GetRegionNotFound() *RegionNotFound {
	if m != nil {
		return m.RegionNotFound
	}
	return nil
}

func (m *Error) GetKeyNotInRegion() *KeyNotInRegion {
	if m != nil {
		return m.KeyNotInRegion
	}
	return nil
}

func (m *Error) GetEpochNotMatch() *EpochNotMatch {
	if m != nil {
		return m.EpochNotMatch
	}
	return nil
}

func (m *Error) GetServerIsBusy() *ServerIsBusy {
	if m != nil {
		return m.ServerIsBusy
	}
	return nil
}

func (m *Error) GetStaleCommand() *StaleCommand {
	if m != nil {
		return m.StaleCommand
	}
	return nil
}

func (m *Error) GetStoreNotMatch() *StoreNotMatch {
	if m != nil {
		return m.StoreNotMatch
	}
	return nil
}

func (m *Error) GetRaftEntryTooLarge() *RaftEntryTooLarge {
	if m != nil {
		return m.RaftEntryTooLarge
	}
	return nil
}

func (m *Error) GetMaxTimestampNotSynced() *MaxTimestampNotSynced {
	if m != nil {
		return m.MaxTimestampNotSynced
	}
	return nil
}

func (m *Error) GetReadIndexNotReady() *ReadIndexNotReady {
	if m != nil {
		return m.ReadIndexNotReady
	}
	return nil
}

func (m *Error) GetProposalInMergingMode() *ProposalInMergingMode {
	if m != nil {
		return m.ProposalInMergingMode
	}
	return nil
}

func (m *Error) GetDataIsNotReady() *DataIsNotReady {
	if m != nil {
		return m.DataIsNotReady
	}
	return nil
}

func (m *Error) GetRegionNotInitialized() *RegionNotInitialized {
	if m != nil {
		return m.RegionNotInitialized
	}
	return nil
}

func (m *Error) GetDiskFull() *DiskFull {
	if m != nil {
		return m.DiskFull
	}
	return nil
}

func (m *Error) GetRecoveryInProgress() *RecoveryInProgress {
	if m != nil {
		return m.RecoveryInProgress
	}
	return nil
}

func init() {
	proto.RegisterType((*NotLeader)(nil), "errorpb.NotLeader")
	proto.RegisterType((*DiskFull)(nil), "errorpb.DiskFull")
	proto.RegisterType((*StoreNotMatch)(nil), "errorpb.StoreNotMatch")
	proto.RegisterType((*RegionNotFound)(nil), "errorpb.RegionNotFound")
	proto.RegisterType((*RegionNotInitialized)(nil), "errorpb.RegionNotInitialized")
	proto.RegisterType((*KeyNotInRegion)(nil), "errorpb.KeyNotInRegion")
	proto.RegisterType((*EpochNotMatch)(nil), "errorpb.EpochNotMatch")
	proto.RegisterType((*ServerIsBusy)(nil), "errorpb.ServerIsBusy")
	proto.RegisterType((*StaleCommand)(nil), "errorpb.StaleCommand")
	proto.RegisterType((*RaftEntryTooLarge)(nil), "errorpb.RaftEntryTooLarge")
	proto.RegisterType((*MaxTimestampNotSynced)(nil), "errorpb.MaxTimestampNotSynced")
	proto.RegisterType((*ReadIndexNotReady)(nil), "errorpb.ReadIndexNotReady")
	proto.RegisterType((*ProposalInMergingMode)(nil), "errorpb.ProposalInMergingMode")
	proto.RegisterType((*DataIsNotReady)(nil), "errorpb.DataIsNotReady")
	proto.RegisterType((*RecoveryInProgress)(nil), "errorpb.RecoveryInProgress")
	proto.RegisterType((*Error)(nil), "errorpb.Error")
}
func (m *NotLeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NotLeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.Leader != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.Leader.Size()))
		n1, err := m.Leader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DiskFull) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiskFull) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StoreId) > 0 {
		dAtA3 := make([]byte, len(m.StoreId)*10)
		var j2 int
		for _, num := range m.StoreId {
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(j2))
		i += copy(dAtA[i:], dAtA3[:j2])
	}
	if len(m.Reason) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.Reason)))
		i += copy(dAtA[i:], m.Reason)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StoreNotMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreNotMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RequestStoreId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RequestStoreId))
	}
	if m.ActualStoreId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.ActualStoreId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RegionNotFound) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionNotFound) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RegionNotInitialized) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionNotInitialized) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *KeyNotInRegion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyNotInRegion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.RegionId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EpochNotMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EpochNotMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CurrentRegions) > 0 {
		for _, msg := range m.CurrentRegions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintErrorpb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServerIsBusy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerIsBusy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reason) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.Reason)))
		i += copy(dAtA[i:], m.Reason)
	}
	if m.BackoffMs != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.BackoffMs))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StaleCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StaleCommand) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RaftEntryTooLarge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftEntryTooLarge) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.EntrySize != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.EntrySize))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MaxTimestampNotSynced) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MaxTimestampNotSynced) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReadIndexNotReady) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadIndexNotReady) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reason) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.Reason)))
		i += copy(dAtA[i:], m.Reason)
	}
	if m.RegionId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProposalInMergingMode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProposalInMergingMode) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DataIsNotReady) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataIsNotReady) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.PeerId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.PeerId))
	}
	if m.SafeTs != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.SafeTs))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RecoveryInProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecoveryInProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	if m.NotLeader != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.NotLeader.Size()))
		n4, err := m.NotLeader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.RegionNotFound != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionNotFound.Size()))
		n5, err := m.RegionNotFound.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.KeyNotInRegion != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.KeyNotInRegion.Size()))
		n6, err := m.KeyNotInRegion.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.EpochNotMatch != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.EpochNotMatch.Size()))
		n7, err := m.EpochNotMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.ServerIsBusy != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.ServerIsBusy.Size()))
		n8, err := m.ServerIsBusy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.StaleCommand != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.StaleCommand.Size()))
		n9, err := m.StaleCommand.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.StoreNotMatch != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.StoreNotMatch.Size()))
		n10, err := m.StoreNotMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.RaftEntryTooLarge != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RaftEntryTooLarge.Size()))
		n11, err := m.RaftEntryTooLarge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.MaxTimestampNotSynced != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.MaxTimestampNotSynced.Size()))
		n12, err := m.MaxTimestampNotSynced.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.ReadIndexNotReady != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.ReadIndexNotReady.Size()))
		n13, err := m.ReadIndexNotReady.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.ProposalInMergingMode != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.ProposalInMergingMode.Size()))
		n14, err := m.ProposalInMergingMode.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.DataIsNotReady != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.DataIsNotReady.Size()))
		n15, err := m.DataIsNotReady.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.RegionNotInitialized != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RegionNotInitialized.Size()))
		n16, err := m.RegionNotInitialized.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.DiskFull != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.DiskFull.Size()))
		n17, err := m.DiskFull.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.RecoveryInProgress != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrorpb(dAtA, i, uint64(m.RecoveryInProgress.Size()))
		n18, err := m.RecoveryInProgress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintErrorpb(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *NotLeader) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.Leader != nil {
		l = m.Leader.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DiskFull) Size() (n int) {
	var l int
	_ = l
	if len(m.StoreId) > 0 {
		l = 0
		for _, e := range m.StoreId {
			l += sovErrorpb(uint64(e))
		}
		n += 1 + sovErrorpb(uint64(l)) + l
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StoreNotMatch) Size() (n int) {
	var l int
	_ = l
	if m.RequestStoreId != 0 {
		n += 1 + sovErrorpb(uint64(m.RequestStoreId))
	}
	if m.ActualStoreId != 0 {
		n += 1 + sovErrorpb(uint64(m.ActualStoreId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegionNotFound) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegionNotInitialized) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyNotInRegion) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EpochNotMatch) Size() (n int) {
	var l int
	_ = l
	if len(m.CurrentRegions) > 0 {
		for _, e := range m.CurrentRegions {
			l = e.Size()
			n += 1 + l + sovErrorpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServerIsBusy) Size() (n int) {
	var l int
	_ = l
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.BackoffMs != 0 {
		n += 1 + sovErrorpb(uint64(m.BackoffMs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StaleCommand) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RaftEntryTooLarge) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.EntrySize != 0 {
		n += 1 + sovErrorpb(uint64(m.EntrySize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MaxTimestampNotSynced) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadIndexNotReady) Size() (n int) {
	var l int
	_ = l
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProposalInMergingMode) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataIsNotReady) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.PeerId != 0 {
		n += 1 + sovErrorpb(uint64(m.PeerId))
	}
	if m.SafeTs != 0 {
		n += 1 + sovErrorpb(uint64(m.SafeTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RecoveryInProgress) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovErrorpb(uint64(m.RegionId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.NotLeader != nil {
		l = m.NotLeader.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.RegionNotFound != nil {
		l = m.RegionNotFound.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.KeyNotInRegion != nil {
		l = m.KeyNotInRegion.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.EpochNotMatch != nil {
		l = m.EpochNotMatch.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.ServerIsBusy != nil {
		l = m.ServerIsBusy.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.StaleCommand != nil {
		l = m.StaleCommand.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.StoreNotMatch != nil {
		l = m.StoreNotMatch.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.RaftEntryTooLarge != nil {
		l = m.RaftEntryTooLarge.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.MaxTimestampNotSynced != nil {
		l = m.MaxTimestampNotSynced.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.ReadIndexNotReady != nil {
		l = m.ReadIndexNotReady.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.ProposalInMergingMode != nil {
		l = m.ProposalInMergingMode.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.DataIsNotReady != nil {
		l = m.DataIsNotReady.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.RegionNotInitialized != nil {
		l = m.RegionNotInitialized.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.DiskFull != nil {
		l = m.DiskFull.Size()
		n += 1 + l + sovErrorpb(uint64(l))
	}
	if m.RecoveryInProgress != nil {
		l = m.RecoveryInProgress.Size()
		n += 2 + l + sovErrorpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovErrorpb(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozErrorpb(x uint64) (n int) {
	return sovErrorpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NotLeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NotLeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NotLeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Leader == nil {
				m.Leader = &metapb.Peer{}
			}
			if err := m.Leader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DiskFull) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiskFull: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiskFull: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowErrorpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.StoreId = append(m.StoreId, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowErrorpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthErrorpb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowErrorpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.StoreId = append(m.StoreId, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreId", wireType)
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreNotMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreNotMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreNotMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestStoreId", wireType)
			}
			m.RequestStoreId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestStoreId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActualStoreId", wireType)
			}
			m.ActualStoreId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ActualStoreId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionNotFound) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionNotFound: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionNotFound: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionNotInitialized) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionNotInitialized: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionNotInitialized: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyNotInRegion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyNotInRegion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyNotInRegion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EpochNotMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EpochNotMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EpochNotMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentRegions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentRegions = append(m.CurrentRegions, &metapb.Region{})
			if err := m.CurrentRegions[len(m.CurrentRegions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerIsBusy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerIsBusy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerIsBusy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackoffMs", wireType)
			}
			m.BackoffMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BackoffMs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StaleCommand) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaleCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaleCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftEntryTooLarge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftEntryTooLarge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftEntryTooLarge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntrySize", wireType)
			}
			m.EntrySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EntrySize |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MaxTimestampNotSynced) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MaxTimestampNotSynced: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MaxTimestampNotSynced: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadIndexNotReady) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadIndexNotReady: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadIndexNotReady: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProposalInMergingMode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProposalInMergingMode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProposalInMergingMode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataIsNotReady) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataIsNotReady: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataIsNotReady: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerId", wireType)
			}
			m.PeerId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PeerId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SafeTs", wireType)
			}
			m.SafeTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SafeTs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecoveryInProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecoveryInProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecoveryInProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotLeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NotLeader == nil {
				m.NotLeader = &NotLeader{}
			}
			if err := m.NotLeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionNotFound", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionNotFound == nil {
				m.RegionNotFound = &RegionNotFound{}
			}
			if err := m.RegionNotFound.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyNotInRegion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeyNotInRegion == nil {
				m.KeyNotInRegion = &KeyNotInRegion{}
			}
			if err := m.KeyNotInRegion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EpochNotMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EpochNotMatch == nil {
				m.EpochNotMatch = &EpochNotMatch{}
			}
			if err := m.EpochNotMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerIsBusy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ServerIsBusy == nil {
				m.ServerIsBusy = &ServerIsBusy{}
			}
			if err := m.ServerIsBusy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaleCommand", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StaleCommand == nil {
				m.StaleCommand = &StaleCommand{}
			}
			if err := m.StaleCommand.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreNotMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StoreNotMatch == nil {
				m.StoreNotMatch = &StoreNotMatch{}
			}
			if err := m.StoreNotMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftEntryTooLarge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RaftEntryTooLarge == nil {
				m.RaftEntryTooLarge = &RaftEntryTooLarge{}
			}
			if err := m.RaftEntryTooLarge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTimestampNotSynced", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxTimestampNotSynced == nil {
				m.MaxTimestampNotSynced = &MaxTimestampNotSynced{}
			}
			if err := m.MaxTimestampNotSynced.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadIndexNotReady", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadIndexNotReady == nil {
				m.ReadIndexNotReady = &ReadIndexNotReady{}
			}
			if err := m.ReadIndexNotReady.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposalInMergingMode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProposalInMergingMode == nil {
				m.ProposalInMergingMode = &ProposalInMergingMode{}
			}
			if err := m.ProposalInMergingMode.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataIsNotReady", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DataIsNotReady == nil {
				m.DataIsNotReady = &DataIsNotReady{}
			}
			if err := m.DataIsNotReady.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionNotInitialized", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionNotInitialized == nil {
				m.RegionNotInitialized = &RegionNotInitialized{}
			}
			if err := m.RegionNotInitialized.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskFull", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DiskFull == nil {
				m.DiskFull = &DiskFull{}
			}
			if err := m.DiskFull.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecoveryInProgress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrorpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RecoveryInProgress == nil {
				m.RecoveryInProgress = &RecoveryInProgress{}
			}
			if err := m.RecoveryInProgress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrorpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrorpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipErrorpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowErrorpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowErrorpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthErrorpb
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowErrorpb
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipErrorpb(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthErrorpb = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowErrorpb   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("errorpb.proto", fileDescriptor_errorpb_643166a07278d6aa) }

var fileDescriptor_errorpb_643166a07278d6aa = []byte{
	// 966 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x96, 0xcd, 0x6e, 0xe3, 0x36,
	0x10, 0xc7, 0xeb, 0x24, 0xeb, 0x8f, 0xb1, 0x2d, 0xc7, 0x42, 0x9c, 0xa8, 0x09, 0x62, 0x2c, 0x84,
	0x62, 0x91, 0x4b, 0x5d, 0x6c, 0xb6, 0x40, 0x81, 0x16, 0x2d, 0xd0, 0x74, 0xb3, 0x58, 0xc3, 0x6b,
	0x37, 0xa0, 0x03, 0xec, 0x51, 0x60, 0xcc, 0xb1, 0x57, 0xb0, 0x24, 0xba, 0x24, 0x15, 0x44, 0x79,
	0x92, 0x3e, 0x42, 0xdf, 0xa3, 0x97, 0x1e, 0x7b, 0xec, 0xb1, 0x48, 0x5f, 0xa4, 0x20, 0x25, 0xdb,
	0x92, 0xe3, 0xba, 0x27, 0x73, 0x86, 0x33, 0x7f, 0x0e, 0xc5, 0xf9, 0x91, 0x86, 0x26, 0x0a, 0xc1,
	0xc5, 0xe2, 0xae, 0xb7, 0x10, 0x5c, 0x71, 0xbb, 0x92, 0x99, 0xa7, 0x8d, 0x10, 0x15, 0x5d, 0xba,
	0x4f, 0x8f, 0x66, 0x7c, 0xc6, 0xcd, 0xf0, 0x2b, 0x3d, 0xca, 0xbc, 0x2d, 0x11, 0x4b, 0x65, 0x86,
	0xa9, 0xc3, 0x1d, 0x41, 0x6d, 0xc4, 0xd5, 0x07, 0xa4, 0x0c, 0x85, 0x7d, 0x06, 0x35, 0x81, 0x33,
	0x9f, 0x47, 0x9e, 0xcf, 0x9c, 0xd2, 0xcb, 0xd2, 0xc5, 0x01, 0xa9, 0xa6, 0x8e, 0x3e, 0xb3, 0xbf,
	0x80, 0x72, 0x60, 0xc2, 0x9c, 0xbd, 0x97, 0xa5, 0x8b, 0xfa, 0x65, 0xa3, 0x97, 0xad, 0x77, 0x83,
	0x28, 0x48, 0x36, 0xe7, 0x7e, 0x0f, 0xd5, 0xb7, 0xbe, 0x9c, 0xbf, 0x8b, 0x83, 0xc0, 0xfe, 0x1c,
	0xaa, 0x52, 0x71, 0x81, 0xa9, 0xda, 0xfe, 0xc5, 0x01, 0xa9, 0x18, 0xbb, 0xcf, 0xec, 0x63, 0x28,
	0x0b, 0xa4, 0x92, 0x47, 0x46, 0xac, 0x46, 0x32, 0xcb, 0xa5, 0xd0, 0x1c, 0xeb, 0x90, 0x11, 0x57,
	0x43, 0xaa, 0x26, 0x9f, 0xec, 0x0b, 0x38, 0x14, 0xf8, 0x4b, 0x8c, 0x52, 0x79, 0x39, 0x2d, 0x5d,
	0x99, 0x95, 0xf9, 0xc7, 0x99, 0xe4, 0x2b, 0x68, 0xd1, 0x89, 0x8a, 0x69, 0xb0, 0x0e, 0xdc, 0x33,
	0x81, 0xcd, 0xd4, 0x9d, 0xc5, 0xb9, 0x5f, 0x82, 0x45, 0xcc, 0x9e, 0x46, 0x5c, 0xbd, 0xe3, 0x71,
	0xc4, 0x76, 0x6e, 0xdb, 0x7d, 0x03, 0x47, 0xab, 0xf0, 0x7e, 0xe4, 0x2b, 0x9f, 0x06, 0xfe, 0x23,
	0xfe, 0x4f, 0x52, 0x0c, 0xd6, 0x00, 0x13, 0x93, 0x91, 0x26, 0xdb, 0x87, 0xb0, 0x3f, 0xc7, 0xc4,
	0x04, 0x36, 0x88, 0x1e, 0x16, 0x05, 0xf6, 0x36, 0x3e, 0xf6, 0x19, 0xd4, 0xa4, 0xa2, 0x42, 0x79,
	0x3a, 0x69, 0xdf, 0x24, 0x55, 0x8d, 0x63, 0x80, 0x89, 0x7d, 0x02, 0x15, 0x8c, 0x98, 0x99, 0x3a,
	0x30, 0x53, 0x65, 0x8c, 0xd8, 0x00, 0x13, 0xf7, 0x3d, 0x34, 0xaf, 0x17, 0x7c, 0xf2, 0x69, 0xf5,
	0xf5, 0xbe, 0x81, 0xd6, 0x24, 0x16, 0x02, 0x23, 0xe5, 0xa5, 0xd2, 0xd2, 0x1c, 0x44, 0xfd, 0xd2,
	0x5a, 0x1e, 0x5e, 0x5a, 0x1e, 0xb1, 0xb2, 0xb0, 0xd4, 0x94, 0xee, 0x35, 0x34, 0xc6, 0x28, 0xee,
	0x51, 0xf4, 0xe5, 0x55, 0x2c, 0x93, 0xdc, 0x79, 0x95, 0xf2, 0xe7, 0x65, 0x9f, 0x03, 0xdc, 0xd1,
	0xc9, 0x9c, 0x4f, 0xa7, 0x5e, 0x28, 0xb3, 0x5d, 0xd4, 0x32, 0xcf, 0x50, 0xba, 0x16, 0x34, 0xc6,
	0x8a, 0x06, 0xf8, 0x13, 0x0f, 0x43, 0x1a, 0x31, 0xf7, 0x67, 0x68, 0x13, 0x3a, 0x55, 0xd7, 0x91,
	0x12, 0xc9, 0x2d, 0xe7, 0x1f, 0xa8, 0x98, 0xe1, 0xee, 0xae, 0x3b, 0x07, 0x40, 0x1d, 0xed, 0x49,
	0xff, 0x11, 0x97, 0x0b, 0x18, 0xcf, 0xd8, 0x7f, 0x44, 0xf7, 0x04, 0x3a, 0x43, 0xfa, 0x70, 0xeb,
	0x87, 0x28, 0x15, 0x0d, 0x17, 0x23, 0xae, 0xc6, 0x49, 0x34, 0x41, 0xe6, 0xbe, 0x87, 0x36, 0x41,
	0xca, 0xfa, 0x11, 0xc3, 0x87, 0x11, 0x57, 0x7a, 0xfc, 0xdf, 0xbb, 0xd8, 0x75, 0x14, 0xee, 0xd7,
	0xd0, 0xb9, 0x11, 0x7c, 0xc1, 0x25, 0x0d, 0xfa, 0xd1, 0x10, 0xc5, 0xcc, 0x8f, 0x66, 0x43, 0xce,
	0x76, 0xd7, 0xed, 0x7a, 0x60, 0xbd, 0xa5, 0x8a, 0xf6, 0xe5, 0x6a, 0xf1, 0x9d, 0xdb, 0x3c, 0x81,
	0xca, 0x02, 0x51, 0xac, 0xd7, 0x2f, 0x6b, 0x33, 0x9d, 0x90, 0x74, 0x8a, 0x9e, 0x92, 0xa6, 0x0d,
	0x0e, 0x48, 0x59, 0x9b, 0xb7, 0xd2, 0x7d, 0x0d, 0x36, 0xc1, 0x09, 0xbf, 0x47, 0x91, 0xf4, 0xa3,
	0x1b, 0xc1, 0x67, 0x02, 0xa5, 0xdc, 0x5d, 0xd3, 0xef, 0x55, 0x78, 0x71, 0xad, 0x2f, 0x0b, 0xdb,
	0x81, 0x4a, 0x88, 0x52, 0xd2, 0x19, 0x66, 0x5f, 0x62, 0x69, 0xda, 0xaf, 0x01, 0x22, 0xae, 0xbc,
	0x02, 0xe9, 0x76, 0x6f, 0x79, 0xe3, 0xac, 0xae, 0x0a, 0x52, 0x8b, 0x56, 0xb7, 0xc6, 0x8f, 0x1a,
	0x51, 0xb3, 0xa6, 0xce, 0x9c, 0x6a, 0xa4, 0x4c, 0xad, 0xf5, 0xcb, 0x93, 0x55, 0x62, 0x91, 0x38,
	0xcd, 0x6e, 0x81, 0xc0, 0x2b, 0x68, 0xcf, 0x31, 0x31, 0xf9, 0x7e, 0x94, 0xb5, 0xaa, 0xe9, 0xed,
	0xbc, 0x46, 0x91, 0x28, 0x62, 0xcd, 0x8b, 0x84, 0xfd, 0x00, 0x2d, 0xd4, 0xcd, 0x6f, 0x54, 0x42,
	0xdd, 0xfe, 0xce, 0x0b, 0xa3, 0x70, 0xbc, 0x52, 0x28, 0xc0, 0x41, 0x9a, 0x58, 0x60, 0xe5, 0x3b,
	0xb0, 0xa4, 0x69, 0x79, 0xcf, 0x97, 0xde, 0x5d, 0x2c, 0x13, 0xa7, 0x6c, 0xd2, 0x3b, 0xab, 0xf4,
	0x3c, 0x11, 0xa4, 0x21, 0xf3, 0x7c, 0x7c, 0x0b, 0x4d, 0xa9, 0x1b, 0xdd, 0x9b, 0xa4, 0x9d, 0xee,
	0x54, 0x36, 0x73, 0x73, 0x18, 0x90, 0x86, 0xcc, 0x59, 0xba, 0xf0, 0xf4, 0xc6, 0x5a, 0x17, 0x5e,
	0xdd, 0x28, 0xbc, 0x70, 0x27, 0x92, 0xa6, 0x2c, 0x5c, 0x91, 0x03, 0x38, 0x12, 0x74, 0xaa, 0xbc,
	0x94, 0x13, 0xc5, 0xb9, 0x17, 0x68, 0xae, 0x9c, 0x9a, 0x11, 0x39, 0x5d, 0x9f, 0xc1, 0x26, 0x79,
	0xa4, 0x2d, 0x9e, 0xc1, 0xf8, 0x11, 0x9c, 0x90, 0x3e, 0x78, 0x6a, 0x49, 0x94, 0x29, 0x4a, 0x1a,
	0xa6, 0x1c, 0x30, 0x82, 0xdd, 0x95, 0xe0, 0x56, 0xf2, 0x48, 0x27, 0xdc, 0xe6, 0x36, 0x55, 0x22,
	0x65, 0x9e, 0xaf, 0x89, 0x34, 0xaa, 0xda, 0x4c, 0x9c, 0xfa, 0x66, 0x95, 0x9b, 0xd4, 0x92, 0xb6,
	0x78, 0x06, 0xf2, 0x47, 0x70, 0x16, 0x19, 0x93, 0xba, 0x61, 0xc2, 0x94, 0x4a, 0x2f, 0xe4, 0x0c,
	0x9d, 0xc6, 0x46, 0x95, 0x5b, 0xe1, 0x25, 0x9d, 0xc5, 0x56, 0xa6, 0xaf, 0xa0, 0xcd, 0xa8, 0xa2,
	0xba, 0x05, 0xd6, 0x25, 0x36, 0x37, 0x1a, 0xb1, 0x08, 0x36, 0xb1, 0x58, 0x11, 0xf4, 0x31, 0x1c,
	0xe7, 0x78, 0xf0, 0xd7, 0x6f, 0x86, 0x63, 0x19, 0xa1, 0xf3, 0xe7, 0x54, 0xe4, 0x1e, 0x16, 0x72,
	0x24, 0xb6, 0x3d, 0x37, 0x3d, 0xa8, 0x31, 0x5f, 0xce, 0xbd, 0x69, 0x1c, 0x04, 0x4e, 0xcb, 0xe8,
	0xb4, 0xd7, 0x05, 0x65, 0x2f, 0x2e, 0xa9, 0xb2, 0xe5, 0xdb, 0x3b, 0xd8, 0x76, 0x3d, 0x38, 0x87,
	0x26, 0xf1, 0x2c, 0x57, 0xc0, 0x66, 0x08, 0xd9, 0x92, 0x46, 0xea, 0x69, 0x6f, 0x1b, 0x5e, 0xae,
	0x5e, 0xfd, 0xf5, 0x5b, 0xb5, 0xf4, 0xc7, 0x53, 0xb7, 0xf4, 0xe7, 0x53, 0xb7, 0xf4, 0xf7, 0x53,
	0xb7, 0xf4, 0xeb, 0x3f, 0xdd, 0xcf, 0xe0, 0x90, 0x8b, 0x59, 0x4f, 0xf9, 0xf3, 0xfb, 0xde, 0xfc,
	0xde, 0xfc, 0xb3, 0xb8, 0x2b, 0x9b, 0x9f, 0x37, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x63, 0x81,
	0x00, 0xca, 0xaf, 0x08, 0x00, 0x00,
}
