/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20140715

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "ergo_input_processor.y"

  /** @file ergo_input_processor.c Parses the input.
      Uses bison code generator to generate the parses.
  */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "ergo_scripted.h"
#define YYERROR_VERBOSE
int yylex(void);
int yyerror(const char *s);
static const char *last_token = NULL;

#line 18 "ergo_input_processor.y"
#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
typedef union {
  double num;     /* for returning numbers */
  char str[256];  /* for returning strings */
  struct variable *var; /* for returning lvalues */
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 49 "ergo_input_processor.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define NUMBER 257
#define DOT 258
#define SYMBOL 259
#define EQUAL 260
#define STRING 261
#define EOFTAG 262
#define GETEXC 263
#define GETPOL 264
#define K_ALL 265
#define HELP 266
#define MOLTAG 267
#define GHOSTTAG 268
#define MOLDAL 269
#define QUIT 270
#define RUNTAG 271
#define SYSTEM 272
#define GHOST 273
#define ANGSTROM 274
#define PRECISION 275
#define RANGE 276
#define WARRANTY 277
#define LIST_DFT_FUNCS 278
#define IS_CHT_USED 279
#define SET_NTHREADS 280
#define PLUS 281
#define MINUS 282
#define TIMES 283
#define DIVIDE 284
#define POWER 285
#define LEFT_PARENTHESIS 286
#define RIGHT_PARENTHESIS 287
#define EOL 288
#define NEG 289
#define YYERRCODE 256
typedef short YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,    3,    3,    3,    3,    4,    4,    2,
    2,    5,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    6,    6,    7,    1,    1,    1,    1,
    1,    1,    1,    1,
};
static const YYINT yylen[] = {                            2,
    0,    1,    3,    0,    1,    1,    1,    3,    3,    1,
    3,    3,    4,    3,    4,    1,    2,    1,    1,    1,
    2,    3,    2,    4,    4,    2,    1,    3,    4,    4,
    1,    6,    7,    1,    2,    5,    1,    3,    3,    3,
    3,    2,    3,    3,
};
static const YYINT yydefred[] = {                         0,
    7,   10,    0,    0,    0,    0,    0,    0,   31,    0,
    0,   20,    0,   27,   18,   19,    0,    0,    0,    0,
    5,    6,    0,    0,    0,    0,    0,    0,    0,   21,
    0,   23,   26,    0,    0,    0,    0,    0,    0,   28,
    0,    0,    0,    0,   34,   12,    0,    0,   14,   22,
    0,    0,   37,    0,    0,    0,    0,   11,    9,    0,
    3,   29,   30,   13,    0,   35,   15,    0,    0,   25,
    0,    0,    0,    0,    0,    0,    0,   24,    0,    0,
    0,   44,    0,    0,    0,    0,    0,    0,   32,    0,
   36,   33,
};
static const YYINT yydgoto[] = {                         18,
   57,   19,   20,   21,   22,   46,   47,
};
static const YYINT yysindex[] = {                      -210,
    0,    0, -256, -248, -255, -264, -253, -198,    0, -219,
 -217,    0, -257,    0,    0,    0, -241,    0, -224, -238,
    0,    0, -206, -165, -203, -214, -251, -207, -251,    0,
 -178,    0,    0, -196, -168, -239, -162, -234, -210,    0,
 -159, -158, -251, -156,    0,    0, -251, -251,    0,    0,
 -155, -157,    0, -183, -254, -254, -205,    0,    0, -190,
    0,    0,    0,    0, -152,    0,    0, -151, -150,    0,
 -177, -197, -254, -254, -254, -254, -254,    0, -148, -149,
 -147,    0, -212, -212, -177, -177, -177, -175,    0, -146,
    0,    0,
};
static const YYINT yyrindex[] = {                         6,
    0,    0,    0,    0,    7,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  111,
    0,    0,    0,    0,   14,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    6,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   15,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   29,   33,    9,   17,   25,    0,    0,    0,
    0,    0,
};
static const YYINT yygindex[] = {                        75,
  -36,  112,    0,    0,    0,  -17,    0,
};
#define YYTABLESIZE 321
static const YYINT yytable[] = {                         34,
   42,   60,   53,    2,   23,    1,   16,   44,   40,   26,
   45,   49,   24,   17,    8,   35,   41,   53,   71,   72,
   28,   54,   53,   27,   43,   64,   59,   55,   38,   66,
   67,   56,   39,   37,   29,   38,   83,   84,   85,   86,
   87,   32,   55,   33,   36,    1,   56,   55,    2,   39,
   40,   56,    3,    4,   37,    5,    6,    7,    8,    9,
   10,   11,   30,   51,   12,   13,   14,   15,   16,   17,
   75,   76,   77,   43,   31,   73,   74,   75,   76,   77,
   48,   78,   50,   73,   74,   75,   76,   77,   52,   82,
   73,   74,   75,   76,   77,   41,   58,   62,   63,   42,
   65,   68,   69,   70,   79,   80,   81,   77,   88,   90,
    2,   89,   91,   61,   92,    0,   25,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   42,   42,   42,   42,    0,    0,   42,   42,   40,
   40,   40,   40,    4,   16,   40,   40,   41,   41,   41,
   41,   17,    8,   41,   41,   43,   43,   43,   43,   38,
   38,   43,   43,   39,   39,   38,   38,    0,    0,   39,
   39,
};
static const YYINT yycheck[] = {                        257,
    0,   38,  257,  259,  261,    0,    0,  259,    0,  274,
  262,   29,  261,    0,    0,  273,    0,  257,   55,   56,
  274,  261,  257,  288,    0,   43,  261,  282,    0,   47,
   48,  286,    0,  258,  288,  260,   73,   74,   75,   76,
   77,  261,  282,  261,  286,  256,  286,  282,  259,  288,
  257,  286,  263,  264,  258,  266,  267,  268,  269,  270,
  271,  272,  261,  260,  275,  276,  277,  278,  279,  280,
  283,  284,  285,  288,  273,  281,  282,  283,  284,  285,
  288,  287,  261,  281,  282,  283,  284,  285,  257,  287,
  281,  282,  283,  284,  285,  261,  259,  257,  257,  265,
  257,  257,  260,  287,  257,  257,  257,  285,  257,  257,
    0,  261,  288,   39,  261,   -1,    5,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,  281,
  282,  283,  284,  288,  288,  287,  288,  281,  282,  283,
  284,  288,  288,  287,  288,  281,  282,  283,  284,  281,
  282,  287,  288,  281,  282,  287,  288,   -1,   -1,  287,
  288,
};
#define YYFINAL 18
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 289
#define YYUNDFTOKEN 299
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NUMBER","DOT","SYMBOL","EQUAL",
"STRING","EOFTAG","GETEXC","GETPOL","K_ALL","HELP","MOLTAG","GHOSTTAG","MOLDAL",
"QUIT","RUNTAG","SYSTEM","GHOST","ANGSTROM","PRECISION","RANGE","WARRANTY",
"LIST_DFT_FUNCS","IS_CHT_USED","SET_NTHREADS","PLUS","MINUS","TIMES","DIVIDE",
"POWER","LEFT_PARENTHESIS","RIGHT_PARENTHESIS","EOL","NEG",0,0,0,0,0,0,0,0,0,
"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : Input",
"Input :",
"Input : Line",
"Input : Line EOL Input",
"Line :",
"Line : Assignment",
"Line : Command",
"Line : error",
"Assignment : Lvalue EQUAL Expression",
"Assignment : Lvalue EQUAL STRING",
"Lvalue : SYMBOL",
"Lvalue : Lvalue DOT SYMBOL",
"Command : MOLTAG EOL Molinput",
"Command : MOLTAG ANGSTROM EOL Molinput",
"Command : GHOSTTAG EOL Molinput",
"Command : GHOSTTAG ANGSTROM EOL Molinput",
"Command : HELP",
"Command : HELP Lvalue",
"Command : LIST_DFT_FUNCS",
"Command : IS_CHT_USED",
"Command : PRECISION",
"Command : MOLDAL STRING",
"Command : MOLDAL GHOST STRING",
"Command : RUNTAG STRING",
"Command : SET_NTHREADS LEFT_PARENTHESIS Expression RIGHT_PARENTHESIS",
"Command : SET_NTHREADS LEFT_PARENTHESIS STRING RIGHT_PARENTHESIS",
"Command : SYSTEM STRING",
"Command : WARRANTY",
"Command : GETEXC STRING NUMBER",
"Command : GETPOL STRING STRING NUMBER",
"Command : GETPOL STRING K_ALL NUMBER",
"Command : QUIT",
"Command : RANGE NUMBER EQUAL NUMBER NUMBER STRING",
"Command : RANGE GHOST NUMBER EQUAL NUMBER NUMBER STRING",
"Molinput : EOFTAG",
"Molinput : Molline Molinput",
"Molline : SYMBOL NUMBER NUMBER NUMBER EOL",
"Expression : NUMBER",
"Expression : Expression PLUS Expression",
"Expression : Expression MINUS Expression",
"Expression : Expression TIMES Expression",
"Expression : Expression DIVIDE Expression",
"Expression : MINUS Expression",
"Expression : Expression POWER Expression",
"Expression : LEFT_PARENTHESIS Expression RIGHT_PARENTHESIS",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 132 "ergo_input_processor.y"

YYSTYPE yylval;
int ergo_scanner_lineno = 1;
int ergo_scanner_reading_stdin = 0;

int yyerror(const char *s) {
  if (last_token) {
    printf("line %d: %s at '%s'\n",ergo_scanner_lineno, s, last_token);
    last_token = NULL;
  } else {
    printf("line %d: %s\n",ergo_scanner_lineno, s);
  }
  return !ergo_scanner_reading_stdin;
}

#ifdef SCANNER_TEST
int main(void) {
  yyparse();
}
#endif
#line 371 "ergo_input_processor.c"

#if YYDEBUG
#include <stdio.h>		/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = YYLEX) < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            yys = yyname[YYTRANSLATE(yychar)];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = yyname[YYTRANSLATE(yychar)];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 7:
#line 54 "ergo_input_processor.y"
	{ if(!ergo_scanner_reading_stdin) { yyerror("Aborted."); YYABORT; } }
break;
case 8:
#line 58 "ergo_input_processor.y"
	{ es_assign_num(yystack.l_mark[-2].var, yystack.l_mark[0].num);}
break;
case 9:
#line 59 "ergo_input_processor.y"
	{ es_assign_str(yystack.l_mark[-2].var, yystack.l_mark[0].str);}
break;
case 10:
#line 63 "ergo_input_processor.y"
	{ yyval.var=es_find_var(NULL, yystack.l_mark[0].str); 
                              if(!yyval.var) { last_token = yystack.l_mark[0].str;
                                        yyerror("Unknown variable");YYERROR; }}
break;
case 11:
#line 66 "ergo_input_processor.y"
	{ yyval.var=es_find_var(yystack.l_mark[-2].var,   yystack.l_mark[0].str);
                              if(!yyval.var) { last_token = yystack.l_mark[0].str;
                                        yyerror("Unknown variable");YYERROR;}}
break;
case 12:
#line 72 "ergo_input_processor.y"
	{ es_mol_commit(); }
break;
case 13:
#line 73 "ergo_input_processor.y"
	{ es_mol_commit(); }
break;
case 14:
#line 74 "ergo_input_processor.y"
	{ es_mol_commit(); }
break;
case 15:
#line 75 "ergo_input_processor.y"
	{ es_mol_commit(); }
break;
case 16:
#line 76 "ergo_input_processor.y"
	{ es_print_help(); }
break;
case 17:
#line 77 "ergo_input_processor.y"
	{ es_print_help_var(yystack.l_mark[0].var); }
break;
case 18:
#line 78 "ergo_input_processor.y"
	{ es_print_list_dft_funcs(); }
break;
case 19:
#line 79 "ergo_input_processor.y"
	{ es_print_is_cht_used(); }
break;
case 20:
#line 80 "ergo_input_processor.y"
	{ es_print_precision(); }
break;
case 21:
#line 81 "ergo_input_processor.y"
	{ if(es_mol_read_molecule(yystack.l_mark[0].str,MOL_MAIN)) { 
                              yyerror("Reading MOLECULE failed"); YYERROR;} }
break;
case 22:
#line 83 "ergo_input_processor.y"
	{ if(es_mol_read_molecule(yystack.l_mark[0].str, MOL_GHOST)) { 
                              yyerror("Reading GHOST MOLECULE failed"); YYERROR;} }
break;
case 23:
#line 85 "ergo_input_processor.y"
	{ if(es_run(yystack.l_mark[0].str, 0)) {
                              yyerror("RUN failed"); YYERROR;} }
break;
case 24:
#line 87 "ergo_input_processor.y"
	{
          if(es_set_nthreads(yystack.l_mark[-1].num)) { yyerror("setNThreads failed"); YYERROR;} }
break;
case 25:
#line 89 "ergo_input_processor.y"
	{
          if(es_set_nthreads_string(yystack.l_mark[-1].str)) { yyerror("setNThreads failed"); YYERROR;} }
break;
case 26:
#line 91 "ergo_input_processor.y"
	{ puts(yystack.l_mark[0].str); 
                   if(system(yystack.l_mark[0].str) != 0) {yyerror("system() failed"); YYERROR;} }
break;
case 27:
#line 93 "ergo_input_processor.y"
	{ es_warranty(); }
break;
case 28:
#line 94 "ergo_input_processor.y"
	{ if(es_getexc(yystack.l_mark[-1].str, yystack.l_mark[0].num)) {
                              yyerror("get_excited_state failed"); YYERROR;} }
break;
case 29:
#line 96 "ergo_input_processor.y"
	{ if(es_get_polarisability(yystack.l_mark[-2].str, yystack.l_mark[-1].str, yystack.l_mark[0].num)) {
                              yyerror("get_polarisability failed"); YYERROR;} }
break;
case 30:
#line 98 "ergo_input_processor.y"
	{ if(es_get_polarisability(yystack.l_mark[-2].str, NULL,yystack.l_mark[0].num)) {
                              yyerror("get_polarisability failed"); YYERROR;} }
break;
case 31:
#line 100 "ergo_input_processor.y"
	{ YYACCEPT; }
break;
case 32:
#line 101 "ergo_input_processor.y"
	{
                         if(!es_assign_range(MOL_MAIN,yystack.l_mark[-4].num, yystack.l_mark[-2].num, yystack.l_mark[-1].num, yystack.l_mark[0].str)) {
                            yyerror("Invalid main basis set range");YYERROR;}
                         }
break;
case 33:
#line 105 "ergo_input_processor.y"
	{
                         if(!es_assign_range(MOL_GHOST,yystack.l_mark[-4].num, yystack.l_mark[-2].num, yystack.l_mark[-1].num, yystack.l_mark[0].str)) {
                            yyerror("Invalid ghost basis set range");YYERROR;}
                         }
break;
case 36:
#line 117 "ergo_input_processor.y"
	{ es_add_atom(yystack.l_mark[-4].str, yystack.l_mark[-3].num, yystack.l_mark[-2].num, yystack.l_mark[-1].num); }
break;
case 37:
#line 121 "ergo_input_processor.y"
	{ yyval.num=yystack.l_mark[0].num;  }
break;
case 38:
#line 122 "ergo_input_processor.y"
	{ yyval.num=yystack.l_mark[-2].num+yystack.l_mark[0].num; }
break;
case 39:
#line 123 "ergo_input_processor.y"
	{ yyval.num=yystack.l_mark[-2].num-yystack.l_mark[0].num; }
break;
case 40:
#line 124 "ergo_input_processor.y"
	{ yyval.num=yystack.l_mark[-2].num*yystack.l_mark[0].num; }
break;
case 41:
#line 125 "ergo_input_processor.y"
	{ yyval.num=yystack.l_mark[-2].num/yystack.l_mark[0].num; }
break;
case 42:
#line 126 "ergo_input_processor.y"
	{ yyval.num=-yystack.l_mark[0].num; }
break;
case 43:
#line 127 "ergo_input_processor.y"
	{ yyval.num=pow(yystack.l_mark[-2].num,yystack.l_mark[0].num); }
break;
case 44:
#line 128 "ergo_input_processor.y"
	{ yyval.num=yystack.l_mark[-1].num; }
break;
#line 736 "ergo_input_processor.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = YYLEX) < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                yys = yyname[YYTRANSLATE(yychar)];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
